/*
 * Decompiled with CFR 0.152.
 */
package vlcskineditor.history;

import vlcskineditor.Item;
import vlcskineditor.history.HistoryEvent;
import vlcskineditor.items.Group;

public class GroupEditEvent
extends HistoryEvent {
    private Group g;
    private String id_old;
    private String id_new;
    private int x_old;
    private int x_new;
    private int y_old;
    private int y_new;

    public GroupEditEvent(Group group) {
        this.g = group;
        this.id_old = this.g.id;
        this.x_old = this.g.x;
        this.y_old = this.g.y;
    }

    public void setNew() {
        this.id_new = this.g.id;
        this.x_new = this.g.x;
        this.y_new = this.g.y;
    }

    @Override
    public void undo() {
        this.g.id = this.id_old;
        this.g.x = this.x_old;
        this.g.y = this.y_old;
        for (Item item : this.g.items) {
            item.setOffset(this.x_old, this.y_old);
        }
    }

    @Override
    public void redo() {
        this.g.id = this.id_new;
        this.g.x = this.x_new;
        this.g.y = this.y_new;
        for (Item item : this.g.items) {
            item.setOffset(this.x_new, this.y_new);
        }
    }

    @Override
    public String getDescription() {
        return "Edit Group";
    }
}

