/*
 * Decompiled with CFR 0.152.
 */
package vlcskineditor.items;

import java.awt.Color;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.net.URI;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;
import vlcskineditor.ActionEditor;
import vlcskineditor.Item;
import vlcskineditor.NumbersOnlyDocument;
import vlcskineditor.Skin;
import vlcskineditor.XML;
import vlcskineditor.history.ButtonEditEvent;
import vlcskineditor.history.ItemAddEvent;

public class Button
extends Item
implements ActionListener {
    public final String DOWN_DEFAULT = "none";
    public final String OVER_DEFAULT = "none";
    public final String ACTION_DEFAULT = "none";
    public final String TOOLTIPTEXT_DEFAULT = "";
    public String up;
    public String down = "none";
    public String over = "none";
    public String action = "none";
    public String tooltiptext = "";
    JFrame frame = null;
    JTextField id_tf;
    JTextField x_tf;
    JTextField y_tf;
    JTextField help_tf;
    JTextField visible_tf;
    JTextField up_tf;
    JTextField down_tf;
    JTextField over_tf;
    JTextField action_tf;
    JTextField tooltiptext_tf;
    JComboBox lefttop_cb;
    JComboBox rightbottom_cb;
    JComboBox xkeepratio_cb;
    JComboBox ykeepratio_cb;
    JButton visible_btn;
    JButton action_btn;
    JButton ok_btn;
    JButton cancel_btn;
    JButton help_btn;
    ActionEditor action_ae;

    public Button(String string, Skin skin) {
        this.type = "Button";
        this.s = skin;
        this.up = XML.getValue(string, "up");
        if (string.indexOf("down=\"") != -1) {
            this.down = XML.getValue(string, "down");
        }
        if (string.indexOf("over=\"") != -1) {
            this.over = XML.getValue(string, "over");
        }
        if (string.indexOf("action=\"") != -1) {
            this.action = XML.getValue(string, "action");
        }
        if (string.indexOf("x=\"") != -1) {
            this.x = XML.getIntValue(string, "x");
        }
        if (string.indexOf("y=\"") != -1) {
            this.y = XML.getIntValue(string, "y");
        }
        this.id = string.indexOf("id=\"") != -1 ? XML.getValue(string, "id") : "Unnamed button #" + this.s.getNewId();
        if (string.indexOf("lefttop=\"") != -1) {
            this.lefttop = XML.getValue(string, "lefttop");
        }
        if (string.indexOf("rightbottom=\"") != -1) {
            this.rightbottom = XML.getValue(string, "rightbottom");
        }
        if (string.indexOf("xkeepratio=\"") != -1) {
            this.xkeepratio = XML.getBoolValue(string, "xkeepratio");
        }
        if (string.indexOf("ykeepratio=\"") != -1) {
            this.ykeepratio = XML.getBoolValue(string, "ykeepratio");
        }
        if (string.indexOf("tooltiptext=\"") != -1) {
            this.tooltiptext = XML.getValue(string, "tooltiptext");
        }
        if (string.indexOf(" visible=\"") != -1) {
            this.visible = XML.getValue(string, "visible");
        }
        this.created = true;
    }

    public Button(Skin skin) {
        this.type = "Button";
        this.s = skin;
        this.up = "";
        this.id = "Unnamed button #" + this.s.getNewId();
        this.showOptions();
    }

    @Override
    public void update() {
        if (!this.created) {
            this.id = this.id_tf.getText();
            this.x = Integer.parseInt(this.x_tf.getText());
            this.y = Integer.parseInt(this.y_tf.getText());
            this.lefttop = this.lefttop_cb.getSelectedItem().toString();
            this.rightbottom = this.rightbottom_cb.getSelectedItem().toString();
            this.xkeepratio = Boolean.parseBoolean(this.xkeepratio_cb.getSelectedItem().toString());
            this.ykeepratio = Boolean.parseBoolean(this.ykeepratio_cb.getSelectedItem().toString());
            this.visible = this.visible_tf.getText();
            this.help = this.help_tf.getText();
            this.up = this.up_tf.getText();
            this.over = this.over_tf.getText();
            this.down = this.down_tf.getText();
            this.action = this.action_tf.getText();
            this.tooltiptext = this.tooltiptext_tf.getText();
            ItemAddEvent itemAddEvent = new ItemAddEvent(this.s.getParentListOf(this.id), this);
            this.s.m.hist.addEvent(itemAddEvent);
            this.s.updateItems();
            this.s.expandItem(this.id);
            this.frame.setDefaultCloseOperation(1);
            this.created = true;
        } else {
            ButtonEditEvent buttonEditEvent = new ButtonEditEvent(this);
            this.id = this.id_tf.getText();
            this.x = Integer.parseInt(this.x_tf.getText());
            this.y = Integer.parseInt(this.y_tf.getText());
            this.lefttop = this.lefttop_cb.getSelectedItem().toString();
            this.rightbottom = this.rightbottom_cb.getSelectedItem().toString();
            this.xkeepratio = Boolean.parseBoolean(this.xkeepratio_cb.getSelectedItem().toString());
            this.ykeepratio = Boolean.parseBoolean(this.ykeepratio_cb.getSelectedItem().toString());
            this.visible = this.visible_tf.getText();
            this.help = this.help_tf.getText();
            this.up = this.up_tf.getText();
            this.over = this.over_tf.getText();
            this.down = this.down_tf.getText();
            this.action = this.action_tf.getText();
            this.tooltiptext = this.tooltiptext_tf.getText();
            buttonEditEvent.setNew();
            this.s.m.hist.addEvent(buttonEditEvent);
            this.s.updateItems();
            this.s.expandItem(this.id);
        }
    }

    @Override
    public void showOptions() {
        if (this.frame == null) {
            this.frame = new JFrame("Button settings");
            this.frame.setResizable(false);
            this.frame.setLayout(new FlowLayout());
            if (!this.created) {
                this.frame.setDefaultCloseOperation(0);
            }
            JLabel jLabel = new JLabel("ID*:");
            this.id_tf = new JTextField();
            JLabel jLabel2 = new JLabel("X:");
            this.x_tf = new JTextField();
            this.x_tf.setDocument(new NumbersOnlyDocument());
            JLabel jLabel3 = new JLabel("Y:");
            this.y_tf = new JTextField();
            this.y_tf.setDocument(new NumbersOnlyDocument());
            String[] stringArray = new String[]{"lefttop", "leftbottom", "righttop", "rightbottom"};
            JLabel jLabel4 = new JLabel("Lefttop:");
            this.lefttop_cb = new JComboBox<String>(stringArray);
            this.lefttop_cb.setToolTipText("Indicate to which corner of the Layout the top-left-hand corner of this item is attached, in case of resizing.");
            JLabel jLabel5 = new JLabel("Rightbottom:");
            this.rightbottom_cb = new JComboBox<String>(stringArray);
            this.rightbottom_cb.setToolTipText("Indicate to which corner of the Layout the bottom-right-hand corner of this item is attached, in case of resizing.");
            Object[] objectArray = new Object[]{true, false};
            JLabel jLabel6 = new JLabel("Keep X Ratio:");
            this.xkeepratio_cb = new JComboBox<Object>(objectArray);
            this.xkeepratio_cb.setToolTipText("When set to true, the behaviour of the horizontal resizing is changed. For example, if initially the space to the left of the control is twice as big as the one to its right, this will stay the same during any horizontal resizing. The width of the control stays constant.");
            JLabel jLabel7 = new JLabel("Keep Y Ratio:");
            this.ykeepratio_cb = new JComboBox<Object>(objectArray);
            this.ykeepratio_cb.setToolTipText("When set to true, the behaviour of the vertical resizing is changed. For example, if initially the space to the top of the control is twice as big as the one to its bottom, this will stay the same during any vertical resizing. The height of the control stays constant.");
            JLabel jLabel8 = new JLabel("Visibility:");
            this.visible_tf = new JTextField();
            this.visible_btn = new JButton("", this.s.m.help_icon);
            this.visible_btn.addActionListener(this);
            JLabel jLabel9 = new JLabel("Help Text:");
            this.help_tf = new JTextField();
            this.help_tf.setToolTipText("Help text for the current control. The variable '$H' will be expanded to this value when the mouse hovers the current control.");
            JLabel jLabel10 = new JLabel("Normal image*:");
            this.up_tf = new JTextField();
            JLabel jLabel11 = new JLabel("Mouse-over image:");
            this.over_tf = new JTextField();
            JLabel jLabel12 = new JLabel("Mouse-click image:");
            this.down_tf = new JTextField();
            JLabel jLabel13 = new JLabel("Action:");
            this.action_tf = new JTextField();
            this.action_btn = new JButton("", this.s.m.editor_icon);
            this.action_btn.addActionListener(this);
            JLabel jLabel14 = new JLabel("Tooltiptext:");
            this.tooltiptext_tf = new JTextField();
            this.ok_btn = new JButton("OK");
            this.ok_btn.addActionListener(this);
            this.ok_btn.setPreferredSize(new Dimension(70, 25));
            this.cancel_btn = new JButton("Cancel");
            this.cancel_btn.addActionListener(this);
            this.cancel_btn.setPreferredSize(new Dimension(70, 25));
            this.help_btn = new JButton("Help");
            this.help_btn.addActionListener(this);
            this.help_btn.setPreferredSize(new Dimension(70, 25));
            JPanel jPanel = new JPanel(null);
            jPanel.add(jLabel);
            jPanel.add(this.id_tf);
            jLabel.setBounds(5, 15, 75, 24);
            this.id_tf.setBounds(85, 15, 150, 24);
            jPanel.add(jLabel2);
            jPanel.add(this.x_tf);
            jLabel2.setBounds(5, 45, 75, 24);
            this.x_tf.setBounds(85, 45, 150, 24);
            jPanel.add(jLabel3);
            jPanel.add(this.y_tf);
            jLabel3.setBounds(5, 75, 75, 24);
            this.y_tf.setBounds(85, 75, 150, 24);
            jPanel.add(jLabel4);
            jPanel.add(this.lefttop_cb);
            jLabel4.setBounds(5, 105, 75, 24);
            this.lefttop_cb.setBounds(85, 105, 150, 24);
            jPanel.add(jLabel5);
            jPanel.add(this.rightbottom_cb);
            jLabel5.setBounds(5, 135, 75, 24);
            this.rightbottom_cb.setBounds(85, 135, 150, 24);
            jPanel.add(jLabel6);
            jPanel.add(this.xkeepratio_cb);
            jLabel6.setBounds(5, 165, 75, 24);
            this.xkeepratio_cb.setBounds(85, 165, 150, 24);
            jPanel.add(jLabel7);
            jPanel.add(this.ykeepratio_cb);
            jLabel7.setBounds(5, 195, 75, 24);
            this.ykeepratio_cb.setBounds(85, 195, 150, 24);
            jPanel.add(jLabel8);
            jPanel.add(this.visible_tf);
            jPanel.add(this.visible_btn);
            jLabel8.setBounds(5, 225, 75, 24);
            this.visible_tf.setBounds(85, 225, 120, 24);
            this.visible_btn.setBounds(210, 225, 24, 24);
            jPanel.add(jLabel9);
            jPanel.add(this.help_tf);
            jLabel9.setBounds(5, 255, 75, 24);
            this.help_tf.setBounds(85, 255, 150, 24);
            jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "General Attributes"));
            jPanel.setMinimumSize(new Dimension(240, 285));
            jPanel.setPreferredSize(new Dimension(240, 285));
            jPanel.setMaximumSize(new Dimension(240, 285));
            this.frame.add(jPanel);
            JPanel jPanel2 = new JPanel(null);
            jPanel2.add(jLabel10);
            jPanel2.add(this.up_tf);
            jLabel10.setBounds(5, 15, 75, 24);
            this.up_tf.setBounds(85, 15, 150, 24);
            jPanel2.add(jLabel11);
            jPanel2.add(this.over_tf);
            jLabel11.setBounds(5, 45, 75, 24);
            this.over_tf.setBounds(85, 45, 150, 24);
            jPanel2.add(jLabel12);
            jPanel2.add(this.down_tf);
            jLabel12.setBounds(5, 75, 75, 24);
            this.down_tf.setBounds(85, 75, 150, 24);
            jPanel2.add(jLabel13);
            jPanel2.add(this.action_tf);
            jPanel2.add(this.action_btn);
            jLabel13.setBounds(5, 105, 75, 24);
            this.action_tf.setBounds(85, 105, 120, 24);
            this.action_btn.setBounds(210, 105, 24, 24);
            jPanel2.add(jLabel14);
            jPanel2.add(this.tooltiptext_tf);
            jLabel14.setBounds(5, 135, 75, 24);
            this.tooltiptext_tf.setBounds(85, 135, 150, 24);
            jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Button Attributes"));
            jPanel2.setMinimumSize(new Dimension(240, 165));
            jPanel2.setPreferredSize(new Dimension(240, 165));
            jPanel2.setMaximumSize(new Dimension(240, 165));
            this.frame.add(jPanel2);
            this.frame.add(this.ok_btn);
            this.frame.add(this.cancel_btn);
            this.frame.add(this.help_btn);
            this.frame.add(new JLabel("* required attribute"));
            this.frame.setMinimumSize(new Dimension(250, 520));
            this.frame.setPreferredSize(new Dimension(250, 520));
            this.frame.setMaximumSize(new Dimension(250, 520));
            this.frame.pack();
            this.frame.getRootPane().setDefaultButton(this.ok_btn);
        }
        this.id_tf.setText(this.id);
        this.x_tf.setText(String.valueOf(this.x));
        this.y_tf.setText(String.valueOf(this.y));
        this.lefttop_cb.setSelectedItem(this.lefttop);
        this.rightbottom_cb.setSelectedItem(this.rightbottom);
        this.xkeepratio_cb.setSelectedItem(this.xkeepratio);
        this.ykeepratio_cb.setSelectedItem(this.ykeepratio);
        this.visible_tf.setText(this.visible);
        this.help_tf.setText(this.help);
        this.up_tf.setText(this.up);
        this.over_tf.setText(this.over);
        this.down_tf.setText(this.down);
        this.action_tf.setText(this.action);
        this.tooltiptext_tf.setText(this.tooltiptext);
        this.frame.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.ok_btn)) {
            if (this.id_tf.getText().equals("")) {
                JOptionPane.showMessageDialog(this.frame, "Please enter a valid ID!", "ID not valid", 1);
                return;
            }
            if (!this.id_tf.getText().equals(this.id) && this.s.idExists(this.id_tf.getText())) {
                JOptionPane.showMessageDialog(this.frame, "The ID \"" + this.id_tf.getText() + "\" already exists, please choose another one.", "ID not valid", 1);
                return;
            }
            if (this.s.getResource(this.up_tf.getText()) == null) {
                JOptionPane.showMessageDialog(this.frame, "The bitmap \"" + this.up_tf.getText() + "\" does not exist!", "Image not valid", 1);
                return;
            }
            if (!this.over_tf.getText().equals("none") && this.s.getResource(this.over_tf.getText()) == null) {
                JOptionPane.showMessageDialog(this.frame, "The bitmap \"" + this.over_tf.getText() + "\" does not exist!", "Image not valid", 1);
                return;
            }
            if (!this.down_tf.getText().equals("none") && this.s.getResource(this.down_tf.getText()) == null) {
                JOptionPane.showMessageDialog(this.frame, "The bitmap \"" + this.down_tf.getText() + "\" does not exist!", "Image not valid", 1);
                return;
            }
            this.update();
            this.frame.setVisible(false);
            this.frame.dispose();
            this.frame = null;
        } else if (actionEvent.getSource().equals(this.help_btn)) {
            if (Desktop.isDesktopSupported()) {
                Desktop desktop = Desktop.getDesktop();
                try {
                    desktop.browse(new URI("http://www.videolan.org/vlc/skinedhlp/i-button.html"));
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, exception.toString(), exception.getMessage(), 0);
                }
            } else {
                JOptionPane.showMessageDialog(null, "Could not launch Browser", "Go to the following URL manually:\nhttp://www.videolan.org/vlc/skinedhlp/i-button.html", 2);
            }
        } else if (actionEvent.getSource().equals(this.visible_btn)) {
            if (Desktop.isDesktopSupported()) {
                Desktop desktop = Desktop.getDesktop();
                try {
                    desktop.browse(new URI("http://www.videolan.org/vlc/skinedhlp/boolexpr.html"));
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, exception.toString(), exception.getMessage(), 0);
                }
            } else {
                JOptionPane.showMessageDialog(null, "Could not launch Browser", "Go to the following URL manually:\nhttp://www.videolan.org/vlc/skinedhlp/boolexpr.html", 2);
            }
        } else if (actionEvent.getSource().equals(this.action_btn)) {
            if (this.action_ae == null) {
                this.action_ae = new ActionEditor(this);
            }
            this.action_ae.editAction(this.action_tf.getText());
        } else if (actionEvent.getSource().equals(this.cancel_btn)) {
            List<Item> list;
            if (!this.created && (list = this.s.getParentListOf(this.id)) != null) {
                list.remove(this);
            }
            this.frame.setVisible(false);
            this.frame.dispose();
            this.frame = null;
        }
    }

    @Override
    public void actionWasEdited(ActionEditor actionEditor) {
        if (actionEditor == this.action_ae) {
            this.action_tf.setText(actionEditor.getCode());
        }
    }

    @Override
    public String returnCode(String string) {
        String string2 = string + "<Button";
        string2 = string2 + " up=\"" + this.up + "\"";
        if (!this.down.equals("none")) {
            string2 = string2 + " down=\"" + this.down + "\"";
        }
        if (!this.over.equals("none")) {
            string2 = string2 + " over=\"" + this.over + "\"";
        }
        if (!this.action.equals("none")) {
            string2 = string2 + " action=\"" + this.action + "\"";
        }
        if (!this.id.equals("Unnamed")) {
            string2 = string2 + " id=\"" + this.id + "\"";
        }
        if (this.x != 0) {
            string2 = string2 + " x=\"" + String.valueOf(this.x) + "\"";
        }
        if (this.y != 0) {
            string2 = string2 + " y=\"" + String.valueOf(this.y) + "\"";
        }
        if (!this.lefttop.equals("lefttop")) {
            string2 = string2 + " lefttop=\"" + this.lefttop + "\"";
        }
        if (!this.rightbottom.equals("lefttop")) {
            string2 = string2 + " rightbottom=\"" + this.rightbottom + "\"";
        }
        if (this.xkeepratio) {
            string2 = string2 + " xkeepratio=\"" + String.valueOf(this.xkeepratio) + "\"";
        }
        if (this.ykeepratio) {
            string2 = string2 + " ykeepratio=\"" + String.valueOf(this.ykeepratio) + "\"";
        }
        if (!this.help.equals("")) {
            string2 = string2 + " help=\"" + this.help + "\"";
        }
        if (!this.visible.equals("true")) {
            string2 = string2 + " visible=\"" + this.visible + "\"";
        }
        if (!this.tooltiptext.equals("")) {
            string2 = string2 + " tooltiptext=\"" + this.tooltiptext + "\"";
        }
        string2 = string2 + "/>";
        return string2;
    }

    @Override
    public void draw(Graphics2D graphics2D, int n) {
        this.draw(graphics2D, this.offsetx, this.offsety, n);
    }

    @Override
    public void draw(Graphics2D graphics2D, int n, int n2, int n3) {
        if (!this.created) {
            return;
        }
        BufferedImage bufferedImage = !this.hovered || this.over.equals("none") && !this.clicked || this.clicked && this.down.equals("none") ? this.s.getBitmapImage(this.up) : (!this.clicked || this.down.equals("none") ? this.s.getBitmapImage(this.over) : this.s.getBitmapImage(this.down));
        if (this.s.gvars.parseBoolean(this.visible)) {
            graphics2D.drawImage(bufferedImage, (this.x + n) * n3, (this.y + n2) * n3, bufferedImage.getWidth() * n3, bufferedImage.getHeight() * n3, null);
        }
        if (this.selected) {
            graphics2D.setColor(Color.RED);
            graphics2D.drawRect((this.x + n) * n3, (this.y + n2) * n3, bufferedImage.getWidth() * n3 - 1, bufferedImage.getHeight() * n3 - 1);
        }
    }

    @Override
    public boolean contains(int n, int n2) {
        BufferedImage bufferedImage = this.s.getBitmapImage(this.up);
        return n >= this.x + this.offsetx && n <= this.x + bufferedImage.getWidth() + this.offsetx && n2 >= this.y + this.offsety && n2 <= this.y + bufferedImage.getHeight() + this.offsety;
    }

    @Override
    public DefaultMutableTreeNode getTreeNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Button: " + this.id);
        return defaultMutableTreeNode;
    }

    @Override
    public boolean uses(String string) {
        return this.up.equals(string) || this.over.equals(string) || this.down.equals(string);
    }
}

